package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type AlignAddLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewAlignAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AlignAddLogic {
	return &AlignAddLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *AlignAddLogic) AlignAdd(req *types.AlignAddReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.AlignAdd(l.ctx, &oa.AlignAddReq{
		UserEmail:         l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		EntityId:          req.EntityId,
		AlignWithEntityId: req.AlignWithEntityId,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
