package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type AlignDelLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewAlignDelLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AlignDelLogic {
	return &AlignDelLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *AlignDelLogic) AlignDel(req *types.AlignDelReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.AlignDel(l.ctx, &oa.AlignDelReq{
		UserEmail:         l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		EntityId:          req.EntityId,
		AlignWithEntityId: req.AlignWithEntityId,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
