package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type AssignAddLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewAssignAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AssignAddLogic {
	return &AssignAddLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *AssignAddLogic) AssignAdd(req *types.AssignAddReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.AssignAdd(l.ctx, &oa.AssignAddReq{
		UserEmail:     l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		EntityId:      req.EntityId,
		IntendedOwner: req.IntendedOwner,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
