package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateKeyResultLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateKeyResultLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateKeyResultLogic {
	return &CreateKeyResultLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateKeyResultLogic) CreateKeyResult(req *types.CreateKeyResultReq) (resp *types.CreateKeyResultResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	in := &oa.CreateKeyResultReq{
		UserEmail:   req.UserEmail,
		Owner:       user.Email,
		OkrId:       req.OkrId,
		ObjectiveId: req.ObjectiveId,
		TypeForKr:   oa.KeyresultType(req.TypeForKR),
		Content:     req.Content,
		Weight:      req.Weight,
		Priority:    req.Priority,
		Deadline:    req.Deadline,
	}
	out, err := l.svcCtx.OkrRpc.CreateKeyResult(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call okrRpc.CreateKeyResult", logx.Field("error", err))
		return nil, err
	}

	return &types.CreateKeyResultResp{KeyResultId: out.GetKeyresultId()}, nil
}
