package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateObjectiveLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateObjectiveLogic {
	return &CreateObjectiveLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateObjectiveLogic) CreateObjective(req *types.CreateObjectiveReq) (resp *types.CreateObjectiveResp, err error) {
	// todo: add your logic here and delete this line
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	rpcResp, err := l.svcCtx.OkrRpc.CreateObjective(l.ctx, &oa.CreateObjectiveReq{
		OkrId:     int64(req.OkrId),
		Content:   req.Content,
		Priority:  req.Priority,
		UserEmail: userEmail,
		Weight:    req.Weight,
		Deadline:  req.Deadline,
	})
	if err != nil {
		l.Logger.Errorw("failed to create okr objective", logx.Field("error", err))
		return nil, err
	}
	return &types.CreateObjectiveResp{
		ObjectiveId: uint64(rpcResp.ObjectiveId),
	}, nil
}
