package okr

import (
	"context"
	"fmt"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateOkrLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateOkrLogic {
	return &CreateOkrLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateOkrLogic) CreateOkr(req *types.CreateOkrReq) (resp *types.CreateOkrResp, err error) {
	// todo: add your logic here and delete this line
	owner := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	userInfo := ctxdata.GetUserInfoFromCtx(l.ctx)
	fmt.Println("用户信息", userInfo, userInfo.DepartmentKeyList, userInfo.OwnerDepartmentList, userInfo.SecondDepartmentList)
	departmentKey := ""
	if len(userInfo.DepartmentKeyList) > 0 {
		departmentKey = userInfo.DepartmentKeyList[0]
	}
	departmentName := ""
	if len(userInfo.DepartmentList) > 0 {
		departmentName = userInfo.DepartmentList[0].DepartmentName
	}
	OkrAddReq := &oa.OkrAddReq{
		Owner:                owner,
		StartDate:            req.StartDate,
		EndDate:              req.EndDate,
		OwnerDepartmentKeys:  departmentKey,
		OwnerDepartmentNames: departmentName,
	}
	rpcResp, err := l.svcCtx.OkrRpc.OkrAdd(l.ctx, OkrAddReq)
	if err != nil {
		l.Logger.Errorw("failed to create okr", logx.Field("error", err))
		return nil, err
	}
	return &types.CreateOkrResp{
		OkrID: rpcResp.OkrId,
	}, nil
}
