package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteKeyResultLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeleteKeyResultLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteKeyResultLogic {
	return &DeleteKeyResultLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeleteKeyResultLogic) DeleteKeyResult(req *types.DeleteKeyResultReq) (resp *types.DeleteKeyResultResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	in := &oa.DeleteKeyResultReq{
		OkrId:       req.OkrId,
		ObjectiveId: req.ObjectiveId,
		KeyresultId: req.KeyResultId,
		Owner:       user.Email,
	}

	_, err = l.svcCtx.OkrRpc.DeleteKeyResult(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call okrRpc.DeleteKeyresult", logx.Field("error", err))
		return nil, err
	}

	return
}
