package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteObjectiveLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeleteObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteObjectiveLogic {
	return &DeleteObjectiveLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeleteObjectiveLogic) DeleteObjective(req *types.DeleteObjectiveReq) (resp *types.DeleteObjectiveResp, err error) {
	// todo: add your logic here and delete this line
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	_, err = l.svcCtx.OkrRpc.DeleteObjective(l.ctx, &oa.DeleteObjectiveReq{
		UserEmail:   userEmail,
		OkrId:       int64(req.OkrId),
		ObjectiveId: int64(req.ObjectiveId),
	})
	if err != nil {
		l.Logger.Errorw("failed to create okr objective", logx.Field("error", err))
		return nil, err
	}
	return &types.DeleteObjectiveResp{}, nil
}
