package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/logic/common"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"
	"oa-server/common/globalkey"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetOkrMenuDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetOkrMenuDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetOkrMenuDataLogic {
	return &GetOkrMenuDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetOkrMenuDataLogic) GetOkrMenuData(req *types.GetOkrMenuDataReq) (resp *types.GetOkrMenuDataResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	// 查询同上级的同事
	peerColleagues, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: user.LeaderEmail})
	if err != nil {
		logx.Errorw("failed to call usercenter.GetLbkUserFollower on GetOkrMenuData.GetPeerColleagues", logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}
	colleagues := make([]types.UserInfo, len(peerColleagues))
	for i, u := range peerColleagues {
		colleagues[i] = types.UserInfo{
			Nickname:        u.NickName,
			Email:           u.Email,
			LarkHeaderImage: u.LarkHeaderImg,
			UserStatus:      int32(u.UserStatus),
			IsLeader:        len(u.OwnerDepartmentList) > 0,
		}
	}

	var departmentUsers []types.DepartmentUser
	var emails []string
	switch user.Email {
	case globalkey.RockyEmail:
		dpKeys := make([]string, len(user.SecondDepartmentList))
		for i, d := range user.SecondDepartmentList {
			dpKeys[i] = d.DepartmentKey
		}
		if len(dpKeys) > 0 {
			dpUsers, err := l.svcCtx.UserRpc.GetDepartmentUserList(l.ctx, &oa.GetDepartmentUserListReq{
				DepartmentKeyList: dpKeys,
			})
			if err != nil {
				logx.Errorw("failed to call oa-userRpc.GetDepartmentUserList on GetOKrMenuData", logx.Field("error", err))
				return nil, err
			}

			// 提取所有用户的email
			// 组装departmentUser
			for _, d := range dpUsers.GetDepartmentUserList() {
				tmpEmails := make([]string, len(d.GetUserList()))
				tmpUserList := make([]types.UserInfo, len(d.GetUserList()))
				for j, u := range d.GetUserList() {
					tmpEmails[j] = u.Email
					tmpUserList[j] = types.UserInfo{
						Nickname:        u.Nickname,
						Email:           u.Email,
						LarkHeaderImage: u.LarkHeaderImage,
						IsLeader:        u.IsLeader,
						UserStatus:      u.UserStatus,
					}
				}

				emails = append(emails, tmpEmails...)

				dpu := types.DepartmentUser{
					DepartmentKey:     d.DepartmentKey,
					DepartmentName:    d.DepartmentName,
					DepartmentLeaders: d.DepartmentLeaders,
					UserList:          tmpUserList,
				}
				departmentUsers = append(departmentUsers, dpu)
			}
		}
	default:
		if len(user.OwnerDepartmentList) > 0 {
			followers, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: user.Email})
			if err != nil {
				logx.Errorw("failed to call usercenter.GetLbkUserFollower on GetOkrMenuData", logx.Field("error", err))
				return nil, common.ErrUsercenterUnavailable
			}

			userList := make([]types.UserInfo, len(followers))
			for i, u := range followers {
				emails = append(emails, u.Email)
				tempUser := types.UserInfo{
					Nickname:        u.NickName,
					Email:           u.Email,
					LarkHeaderImage: u.LarkHeaderImg,
					UserStatus:      int32(u.UserStatus),
					IsLeader:        len(u.OwnerDepartmentList) > 0,
				}
				userList[i] = tempUser
			}

			departmentUsers = append(departmentUsers, types.DepartmentUser{
				DepartmentKey:     user.OwnerDepartmentList[0].DepartmentKey,
				DepartmentName:    user.OwnerDepartmentList[0].DepartmentName,
				UserList:          userList,
				DepartmentLeaders: []string{user.Email},
			})

		}
	}

	// 请求okr状态信息,
	if len(emails) > 0 {
		okrList, err := l.svcCtx.OkrRpc.ListOkrPeriod(l.ctx, &oa.ListOkrPeriodReq{
			EmailList: emails,
			StartDate: req.StartDate,
			EndDate:   req.EndDate,
			PageSize:  9999,
			PageNum:   1,
		})
		if err != nil {
			logx.Errorw("failed to call okrRpc.ListOkrPeriod on GetOkrMenuData", logx.Field("error", err))
			return nil, err
		}

		okrMap := convertOkrPeriodListToMap(okrList.GetList())

		for i, d := range departmentUsers {
			for j, u := range d.UserList {
				if o, ok := okrMap[u.Email]; ok {
					departmentUsers[i].UserList[j].OkrStatus = int32(o.ApprovalStatus)
				}
			}
		}
	}

	return &types.GetOkrMenuDataResp{PeerColleagues: colleagues, DepartmentUserList: departmentUsers}, nil
}

func convertOkrPeriodListToMap(list []*oa.OkrPeriod) map[string]*oa.OkrPeriod {
	m := make(map[string]*oa.OkrPeriod, len(list))
	for _, v := range list {
		m[v.Owner] = v
	}

	return m
}
