package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type MessageAlignHandleLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewMessageAlignHandleLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MessageAlignHandleLogic {
	return &MessageAlignHandleLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MessageAlignHandleLogic) MessageAlignHandle(req *types.MessageAlignHandleReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.MessageAlignHandle(l.ctx, &oa.MessageAlignHandleReq{
		UserEmail: l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		MessageId: req.MessageId,
		Status:    req.Status,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
