package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type MessageAssignHandleLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewMessageAssignHandleLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MessageAssignHandleLogic {
	return &MessageAssignHandleLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MessageAssignHandleLogic) MessageAssignHandle(req *types.MessageAssignHandleReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.MessageAssignHandle(l.ctx, &oa.MessageAssignHandleReq{
		UserEmail:          l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		MessageId:          req.MessageId,
		Status:             req.Status,
		KrUnderObjectiveId: req.KrUnderObjectiveId,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
