package okr

import (
	"context"
	"encoding/json"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type MessageListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewMessageListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MessageListLogic {
	return &MessageListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *MessageListLogic) MessageList(req *types.MessageListReq) (resp *types.MessageListResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	rpcResp, err := l.svcCtx.OkrRpc.MessageList(l.ctx, &oa.MessageListReq{
		PageNum:   int64(req.Page),
		PageSize:  int64(req.PageSize),
		StartDate: req.StartDate,
		EndDate:   req.EndDate,
		UserEmail: userEmail,
	})
	if err != nil {
		return nil, err
	}
	list := make([]types.Message, 0)
	for _, item := range rpcResp.List {
		data := make(map[string]any)
		if err := json.Unmarshal([]byte(item.ExtraData), &data); err != nil {
			logx.Errorw("json.Unmarshal failed", logx.Field("err", err), logx.Field("extra_data", item.ExtraData))
			continue
		}
		list = append(list, types.Message{
			ID:          uint64(item.Id),
			UserEmail:   item.UserEmail,
			MessageType: int(item.MessageType),
			Status:      int(item.Status),
			CreatedAt:   item.CreatedAt,
			UpdatedAt:   item.UpdatedAt,
			ExtraData:   data,
		})
	}
	return &types.MessageListResp{
		List:  list,
		Total: int(rpcResp.Total),
	}, nil

}
