package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrAckLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrAckLogic {
	return &OkrAckLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrAckLogic) OkrAck(req *types.OkrAckReq) (resp *types.EmptyResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	_, err = l.svcCtx.OkrRpc.OkrAck(l.ctx, &oa.OkrAckReq{
		OkrId: req.OkrId,
		AckBy: userEmail,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
