package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrApplyAckLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrApplyAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrApplyAckLogic {
	return &OkrApplyAckLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrApplyAckLogic) OkrApplyAck(req *types.OkrApplyAckReq) (resp *types.EmptyResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	_, err = l.svcCtx.OkrRpc.OkrApplyAck(l.ctx, &oa.OkrApplyAckReq{
		OkrId:      req.OkrId,
		ApplyAckBy: userEmail,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
