package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrDetailLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrDetailLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrDetailLogic {
	return &OkrDetailLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrDetailLogic) OkrDetail(req *types.OkrDetailReq) (resp *types.OkrDetailResp, err error) {
	signInUserEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	dataUserEmail := req.UserEmail
	if dataUserEmail == "" {
		dataUserEmail = signInUserEmail
	}
	rpcResp, err := l.svcCtx.OkrRpc.OkrDetail(l.ctx, &oa.OkrDetailReq{
		DataUserEmail:     dataUserEmail,
		SignedInUserEmail: signInUserEmail,
		StartDate:         req.StartDate,
		EndDate:           req.EndDate,
	})
	if err != nil {
		return nil, err
	}
	if rpcResp.OkrId == 0 {
		return &types.OkrDetailResp{UnHandledMessages: rpcResp.UnHandledMessages}, nil
	}
	rtn := &types.OkrDetailResp{
		OkrId:             rpcResp.OkrId,
		UserEmail:         rpcResp.UserEmail,
		StartDate:         rpcResp.StartDate,
		EndDate:           rpcResp.EndDate,
		Status:            rpcResp.Status,
		Children:          make([]*types.OKRTreeElem, 0),
		UnHandledMessages: rpcResp.UnHandledMessages,
	}
	for _, child := range rpcResp.Children {
		rtn.Children = append(rtn.Children, rpcOKRTreeElemToApiOKRTreeElem(child))
	}
	return rtn, nil
}

func rpcOKRTreeElemToApiOKRTreeElem(elem *oa.OKRTreeElem) *types.OKRTreeElem {
	rtn := &types.OKRTreeElem{
		OKREntityView: types.OKREntityView{
			AlignWithParent:              elem.Entity.AlignWithParent,
			AlignWithParentByAssign:      elem.Entity.AlignWithParentByAssign,
			ByAssign:                     elem.Entity.ByAssign,
			EntityId:                     elem.Entity.EntityId,
			EntityType:                   elem.Entity.EntityType,
			ParentEntityId:               elem.Entity.ParentEntityId,
			Content:                      elem.Entity.Content,
			Priority:                     elem.Entity.Priority,
			Deadline:                     elem.Entity.Deadline,
			TypeForKr:                    elem.Entity.TypeForKr,
			Owner:                        elem.Entity.Owner,
			Position:                     elem.Entity.Position,
			Weight:                       elem.Entity.Weight,
			IntendedOwner:                elem.Entity.IntendedOwner,
			IntendedAlign:                elem.Entity.IntendedAlign,
			EditableFieldsBySignedInUser: elem.Entity.EditableBySignedInUser,
		},
		AlignWith: make([]*types.OKRTreeElem, 0),
		Children:  make([]*types.OKRTreeElem, 0),
	}
	for _, child := range elem.AlignWith {
		rtn.AlignWith = append(rtn.AlignWith, rpcOKRTreeElemToApiOKRTreeElem(child))
	}
	for _, child := range elem.Children {
		rtn.Children = append(rtn.Children, rpcOKRTreeElemToApiOKRTreeElem(child))
	}
	return rtn
}
