package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrPosUpdateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrPosUpdateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrPosUpdateLogic {
	return &OkrPosUpdateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrPosUpdateLogic) OkrPosUpdate(req *types.OkrPosUpdateReq) (resp *types.EmptyResp, err error) {
	_, err = l.svcCtx.OkrRpc.OkrPosUpdate(l.ctx, &oa.OkrPosUpdateReq{
		UserEmail:      l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		ParentEntityId: req.ParentEntityId,
		EntityIds:      req.EntityIds,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
