package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrSuggestModifyLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrSuggestModifyLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrSuggestModifyLogic {
	return &OkrSuggestModifyLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrSuggestModifyLogic) OkrSuggestModify(req *types.OkrSuggestModifyReq) (resp *types.EmptyResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	_, err = l.svcCtx.OkrRpc.OkrSuggestModify(l.ctx, &oa.OkrSuggestModifyReq{
		OkrId:           req.OkrId,
		SuggestModifyBy: userEmail,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
