package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrTaskAddLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrTaskAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrTaskAddLogic {
	return &OkrTaskAddLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrTaskAddLogic) OkrTaskAdd(req *types.CreateOkrTaskReq) (resp *types.EmptyResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	if req.UserEmail == "" {
		req.UserEmail = userEmail
	}
	_, err = l.svcCtx.OkrRpc.OkrTaskAdd(l.ctx, &oa.OkrTaskAddReq{
		OkrId:       req.OkrId,
		ObjectiveId: req.ObjectiveId,
		KeyresultId: req.KeyResultId,
		UserEmail:   req.UserEmail,
		Content:     req.Content,
		Weight:      req.Weight,
		Priority:    req.Priority,
		Deadline:    req.Deadline,
		Operator:    userEmail,
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
