package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrTaskDeleteLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewOkrTaskDeleteLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrTaskDeleteLogic {
	return &OkrTaskDeleteLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *OkrTaskDeleteLogic) OkrTaskDelete(req *types.DeleteOkrTaskReq) (resp *types.EmptyResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
  _, err = l.svcCtx.OkrRpc.OkrTaskDelete(l.ctx, &oa.OkrTaskDeleteReq{
    OkrId: req.OkrId,
    ObjectiveId: req.ObjectiveId,
    KeyresultId: req.KeyResultId,
    TaskId: req.TaskId,
    UserEmail: userEmail,
  })
  if err != nil {
    return nil, err
  }
  return &types.EmptyResp{}, nil
}
