package okr

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateKeyResultLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateKeyResultLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateKeyResultLogic {
	return &UpdateKeyResultLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateKeyResultLogic) UpdateKeyResult(req *types.UpdateKeyResultReq) (resp *types.UpdateKeyResultResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	in := &oa.UpdateKeyResultReq{
		OkrId:       req.OkrId,
		ObjectiveId: req.ObjectiveId,
		KeyresultId: req.KeyResultId,
		UserEmail:   req.UserEmail,
		TypeForKr:   oa.KeyresultType(req.TypeForKR),
		Content:     req.Content,
		Weight:      req.Weight,
		Priority:    req.Priority,
		Deadline:    req.Deadline,
		Owner:       user.Email,
	}
	_, err = l.svcCtx.OkrRpc.UpdateKeyResult(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call okrRpc.UpdateKeyresult", logx.Field("error", err))
		return nil, err
	}

	return &types.UpdateKeyResultResp{}, nil
}
