package okr

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateObjectiveLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateObjectiveLogic {
	return &UpdateObjectiveLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateObjectiveLogic) UpdateObjective(req *types.UpdateObjectiveReq) (resp *types.UpdateObjectiveResp, err error) {
	// todo: add your logic here and delete this line
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	_, err = l.svcCtx.OkrRpc.UpdateObjective(l.ctx, &oa.UpdateObjectiveReq{
		OkrId:       int64(req.OkrId),
		ObjectiveId: int64(req.ObjectiveId),
		Content:     req.Content,
		Priority:    req.Priority,
		UserEmail:   userEmail,
		Weight:      req.Weight,
		Deadline:    req.Deadline,
	})
	if err != nil {
		l.Logger.Errorw("failed to update okr objective", logx.Field("error", err))
		return nil, err
	}
	return &types.UpdateObjectiveResp{}, nil
}
