package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreatePerformanceItemCommentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreatePerformanceItemCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreatePerformanceItemCommentLogic {
	return &CreatePerformanceItemCommentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreatePerformanceItemCommentLogic) CreatePerformanceItemComment(req *types.CreatePerformanceItemCommentReq) (resp *types.CreatePerformanceItemCommentResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.CreatePerformanceItemCommentReq{
		PerformanceId: req.PerformanceID,
		ItemId:        req.ItemID,
		CommentType:   oa.PerformanceCommentType(req.CommentType),
		UserEmail:     userEmail,
		Comment:       req.Comment,
	}
	out, err := l.svcCtx.PerformanceRpc.CreatePerformanceItemComment(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.CreatePerformanceItemComment", logx.Field("error", err))
		return nil, err
	}
	resp = new(types.CreatePerformanceItemCommentResp)
	resp.CommentID = out.GetCommentId()

	return
}
