package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreatePerformanceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreatePerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreatePerformanceLogic {
	return &CreatePerformanceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreatePerformanceLogic) CreatePerformance(req *types.CreatePerformanceReq) (resp *types.CreatePerformanceResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.CreatePerformanceReq{
		UserEmail: userEmail,
		Year:      req.Year,
		MonthNum:  req.MonthNum,
	}
	out, err := l.svcCtx.PerformanceRpc.CreatePerformance(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.CreatePerformance", logx.Field("error", err))
		return
	}
	resp = &types.CreatePerformanceResp{ID: out.GetId()}
	return
}
