package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreatePerformanceWorkItemLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreatePerformanceWorkItemLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreatePerformanceWorkItemLogic {
	return &CreatePerformanceWorkItemLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreatePerformanceWorkItemLogic) CreatePerformanceWorkItem(req *types.CreatePerformanceWorkItemReq) (resp *types.CreatePerformanceWorkItemResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := oa.CreatePerformanceWorkItemReq{
		PerformanceId: req.PerformanceID,
		UserEmail:     userEmail,
		ItemName:      req.ItemName,
		ItemWeight:    req.ItemWeight,
		ItemDesc:      req.ItemDesc,
		ItemDeficency: req.ItemDeficency,
		SelfScore:     req.SelfScore,
	}

	out, err := l.svcCtx.PerformanceRpc.CreatePerformanceWorkItem(l.ctx, &in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.CreatePerformanceWorkItem", logx.Field("error", err))
		return nil, err
	}

	return &types.CreatePerformanceWorkItemResp{ItemID: out.ItemId}, nil
}
