package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeletePerformanceItemCommentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeletePerformanceItemCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeletePerformanceItemCommentLogic {
	return &DeletePerformanceItemCommentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeletePerformanceItemCommentLogic) DeletePerformanceItemComment(req *types.DeletePerformanceItemCommentReq) (resp *types.DeletePerformanceItemCommentResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.DeletePerformanceItemCommentReq{
		UserEmail:     userEmail,
		PerformanceId: req.PerformanceID,
		CommentId:     req.CommentID,
	}
	_, err = l.svcCtx.PerformanceRpc.DeletePerformanceItemComment(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.DeletePerformanceItemComment", logx.Field("error", err))
		return nil, err
	}

	return &types.DeletePerformanceItemCommentResp{}, nil
}
