package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeletePerformanceWorkItemLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeletePerformanceWorkItemLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeletePerformanceWorkItemLogic {
	return &DeletePerformanceWorkItemLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeletePerformanceWorkItemLogic) DeletePerformanceWorkItem(req *types.DeletePerformanceWorkItemReq) (resp *types.DeletePerformanceWorkItemResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := oa.DeletePerformanceWorkItemReq{ItemId: req.ItemID, UserEmail: userEmail}
	_, err = l.svcCtx.PerformanceRpc.DeletePerformanceWorkItem(l.ctx, &in)
	if err != nil {
		return nil, err
	}

	return
}
