package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type FinishLeaderEvaluationLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewFinishLeaderEvaluationLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FinishLeaderEvaluationLogic {
	return &FinishLeaderEvaluationLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *FinishLeaderEvaluationLogic) FinishLeaderEvaluation(req *types.FinishLeaderEvaluationReq) (resp *types.FinishLeaderEvaluationResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.FinishLeaderEvaluationReq{PerformanceId: req.PerformanceID, UserEmail: userEmail}
	_, err = l.svcCtx.PerformanceRpc.FinishLeaderEvaluation(l.ctx, in)

	return
}
