package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type FinishPerformanceWorkloadFillingLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewFinishPerformanceWorkloadFillingLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FinishPerformanceWorkloadFillingLogic {
	return &FinishPerformanceWorkloadFillingLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *FinishPerformanceWorkloadFillingLogic) FinishPerformanceWorkloadFilling(req *types.FinishPerformanceWorkloadFillingReq) (resp *types.FinishPerformanceWorkloadFillingResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.FinishPerformanceWorkloadFillingReq{UserEmail: userEmail, PerformanceId: req.PerformanceID}
	_, err = l.svcCtx.PerformanceRpc.FinishPerformanceWorkloadFilling(l.ctx, in)

	return
}
