package performance

import (
	"context"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"
	"time"
)

type GetPerformanceAdditionScoreListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetPerformanceAdditionScoreListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetPerformanceAdditionScoreListLogic {
	return &GetPerformanceAdditionScoreListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetPerformanceAdditionScoreListLogic) GetPerformanceAdditionScoreList(req *types.GetPerformanceAdditionScoreListReq) (resp *types.GetPerformanceAdditionScoreListResp, err error) {
	// todo: add your logic here and delete this line
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.GetPerformanceAdditionScoreListReq{
		Year:          req.Year,
		UserEmail:     req.UserEmail,
		MonthNum:      req.MonthNum,
		CoworkerEmail: userEmail,
		PageNum:       req.PageNum,
		PageSize:      req.PageSize,
		OrderBy:       "`id` desc",
	}
	out, err := l.svcCtx.PerformanceRpc.GetPerformanceAdditionScoreList(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.GetPerformanceItemCommentList", logx.Field("error", err))
		return nil, err
	}

	comments := make([]types.PerformanceAdditionScore, len(out.List))
	for i, v := range out.List {
		comments[i] = types.PerformanceAdditionScore{
			ID:            v.Id,
			PerformanceId: v.PerformanceId,
			ItemID:        v.ItemId,
			Year:          v.Year,
			MonthNum:      v.MonthNum,
			Status:        v.Status,
			ItemDesc:      v.ItemDesc,
			Score:         v.Score,
			UserEmail:     v.UserEmail,
			CoworkerEmail: v.CoworkerEmail,
			CreatedAt:     v.CreatedAt.AsTime().Local().Format(time.DateTime),
			UpdatedAt:     v.UpdatedAt.AsTime().Local().Format(time.DateTime),
		}
	}
	return &types.GetPerformanceAdditionScoreListResp{
		Total: out.Total,
		List:  comments,
	}, err

	// 由于请求的时候是按id倒序排序的，所以还需要恢复评论的顺序。
	//sort.SliceStable(comments, func(i, j int) bool { return comments[i].CommentID < comments[j].CommentID })

	//return &types.GetPerformanceAdditionScoreListResp{Total: 16, List: append([]types.PerformanceAdditionScore{},
	//	types.PerformanceAdditionScore{
	//		ID:            1,
	//		Score:         100,
	//		CreatedAt:     time.Now().Format(time.DateTime),
	//		UpdatedAt:     time.Now().Format(time.DateTime),
	//		ItemDesc:      "123",
	//		MonthNum:      1,
	//		PerformanceId: 1,
	//		Year:          1,
	//		Status:        1,
	//		//CoworkerEmail: "123",
	//		UserEmail: userEmail,
	//	}, types.PerformanceAdditionScore{
	//		ID:            1,
	//		Score:         100,
	//		CreatedAt:     time.Now().Format(time.DateTime),
	//		UpdatedAt:     time.Now().Format(time.DateTime),
	//		ItemDesc:      "123",
	//		MonthNum:      1,
	//		PerformanceId: 1,
	//		Year:          1,
	//		Status:        1,
	//		//CoworkerEmail: "123",
	//		UserEmail: userEmail,
	//	}),
	//}, nil

}
