package performance

import (
	"context"
	"time"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetPerformanceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetPerformanceLogic {
	return &GetPerformanceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetPerformanceLogic) GetPerformance(req *types.GetPerformanceReq) (resp *types.GetPerformanceResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.GetPerformanceReq{
		UserEmail: userEmail,
		Year:      req.Year,
		MonthNum:  req.MonthNum,
	}
	out, err := l.svcCtx.PerformanceRpc.GetPerformance(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.GetPerformance", logx.Field("error", err))
		return
	}

	resp = &types.GetPerformanceResp{List: make([]types.Performance, len(out.List))}
	for i, p := range out.List {
		resp.List[i] = types.Performance{
			ID:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			LeaderWords:        p.LeaderWords,
			Status:             int32(p.Status),
			CreatedAt:          p.CreatedAt.AsTime().Local().Format(time.DateTime),
			UpdatedAt:          p.UpdatedAt.AsTime().Local().Format(time.DateTime),
		}
	}

	return
}
