package performance

import (
	"context"
	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"oa-server/app/oacenter/oa_api/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"
	"oa-server/common/globalkey"
	"strings"
	"time"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetPerformanceMenuDataLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetPerformanceMenuDataLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetPerformanceMenuDataLogic {
	return &GetPerformanceMenuDataLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetPerformanceMenuDataLogic) GetPerformanceMenuData(req *types.GetPerformanceMenuDataReq) (resp *types.GetPerformanceMenuDataResp, err error) {
	// todo: add your logic here and delete this line
	user := ctxdata.GetUserInfoFromCtx(l.ctx)
	var departmentUsers []types.DepartmentUser
	var emails []string
	// 获取用户的下属
	userList := make([]types.UserInfo, 0)
	if len(user.OwnerDepartmentList) > 0 {
		//followers, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: user.Email})

		//getDepartmentDirectlyUserReq := usercenter.GetDepartmentDirectlyUserReq{
		//	AppKey:        l.svcCtx.Config.LbkUsercenter.AppName,
		//	AppToken:      l.svcCtx.Config.LbkUsercenter.AppToken,
		//	DepartmentKey: departmentKey,
		//}
		//followers, err = l.svcCtx.LbkUcClient.GetDepartmentDirectlyUser(l.ctx, getDepartmentDirectlyUserReq) // rocky

		followers, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: user.Email}) // 不是rocky  yunshu
		if err != nil {
			logx.Errorw("failed to call usercenter.GetLbkUserFollower on GetOkrMenuData", logx.Field("error", err))
			return nil, common.ErrUsercenterUnavailable
		}

		for _, u := range followers {
			emails = append(emails, u.Email)
			tempUser := types.UserInfo{
				Nickname:        u.NickName,
				Email:           u.Email,
				LarkHeaderImage: u.LarkHeaderImg,
				UserStatus:      int32(u.UserStatus),
				IsLeader:        len(u.OwnerDepartmentList) > 0,
				JoinTime:        u.JoinTime,
				JoinDate:        time.Unix(u.JoinTime, 0).Format(time.DateOnly),
			}
			userList = append(userList, tempUser)
		}
	}
	// 获取用户的部门 rocky
	switch user.Email {
	case globalkey.RockyEmail:
		dpKeys := make([]string, len(user.SecondDepartmentList))
		for i, d := range user.SecondDepartmentList {
			dpKeys[i] = d.DepartmentKey
		}
		if len(dpKeys) > 0 {
			dpUsers, err := l.svcCtx.UserRpc.GetDepartmentUserList(l.ctx, &oa.GetDepartmentUserListReq{
				DepartmentKeyList: dpKeys,
			})
			if err != nil {
				logx.Errorw("failed to call oa-userRpc.GetDepartmentUserList on GetOKrMenuData", logx.Field("error", err))
				return nil, err
			}

			// 提取所有用户的email
			// 组装departmentUser
			for _, d := range dpUsers.GetDepartmentUserList() {
				tmpEmails := make([]string, len(d.GetUserList()))
				tmpUserList := make([]types.UserInfo, len(d.GetUserList()))
				for j, u := range d.GetUserList() {
					tmpEmails[j] = u.Email
					tmpUserList[j] = types.UserInfo{
						Nickname:        u.Nickname,
						Email:           u.Email,
						LarkHeaderImage: u.LarkHeaderImage,
						IsLeader:        u.IsLeader,
						UserStatus:      u.UserStatus,
						JoinTime:        u.JoinTime,
						JoinDate:        time.Unix(u.JoinTime, 0).Format(time.DateOnly),
					}
				}

				emails = append(emails, tmpEmails...)

				dpu := types.DepartmentUser{
					DepartmentKey:     d.DepartmentKey,
					DepartmentName:    d.DepartmentName,
					DepartmentLeaders: d.DepartmentLeaders,
					UserList:          tmpUserList,
				}
				departmentUsers = append(departmentUsers, dpu)
			}
		}
		/*default:
		if len(user.OwnerDepartmentList) > 0 {
			followers, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: user.Email})
			if err != nil {
				logx.Errorw("failed to call usercenter.GetLbkUserFollower on GetOkrMenuData", logx.Field("error", err))
				return nil, common.ErrUsercenterUnavailable
			}

			userList1 := make([]types.UserInfo, len(followers))
			for i, u := range followers {
				emails = append(emails, u.Email)
				tempUser := types.UserInfo{
					Nickname:        u.NickName,
					Email:           u.Email,
					LarkHeaderImage: u.LarkHeaderImg,
					UserStatus:      int32(u.UserStatus),
					IsLeader:        len(u.OwnerDepartmentList) > 0,
				}
				userList1[i] = tempUser
			}

			departmentUsers = append(departmentUsers, types.DepartmentUser{
				DepartmentKey:     user.OwnerDepartmentList[0].DepartmentKey,
				DepartmentName:    user.OwnerDepartmentList[0].DepartmentName,
				UserList:          userList1,
				DepartmentLeaders: []string{user.Email},
			})

		}*/
	}
	// 请求绩效状态信息
	if len(emails) > 0 {
		list, err := l.svcCtx.PerformanceRpc.GetPerformanceRanking(l.ctx, &oa.GetPerformanceRankingReq{
			Year:      req.Year,
			MonthNum:  req.MonthNum,
			PageSize:  999,
			PageNum:   1,
			UserEmail: user.Email,
			SortField: "total_score",
			SortOrder: "desc",
		})
		if err != nil {
			logx.Errorw("failed to call performanceRpc.ListPerformance on GetPerformanceMenuData", logx.Field("error", err))
			return nil, err
		}
		performanceMap := convertPerformanceListToMap(list.GetList())
		//fmt.Println("performanceMap", performanceMap)
		for i, d := range departmentUsers {
			for j, u := range d.UserList {
				if o, ok := performanceMap[extractEmailUsername(u.Email)]; ok { //list返回的是邮箱前缀，需要截取
					//fmt.Println("performanceMap666", i, j, u.Email, o.Status, o.Status.String() == "DONE", oa.PerformanceStatus_value, oa.PerformanceStatus_value[o.Status.String()])
					departmentUsers[i].UserList[j].Status = int32(o.Status) //oa.PerformanceStatus_value[o.Status.String()] //如果没有绩效，绩效表搜不到，没有填写，那么默认就是0
				}
			}
		}
		for i, u := range userList {
			if o, ok := performanceMap[extractEmailUsername(u.Email)]; ok {
				userList[i].Status = oa.PerformanceStatus_value[o.Status.String()]
			}
		}
	}
	return &types.GetPerformanceMenuDataResp{Followers: userList, DepartmentUserList: departmentUsers}, nil
}
func convertPerformanceListToMap(list []*oa.PerformanceRanking) map[string]*oa.PerformanceRanking {
	m := make(map[string]*oa.PerformanceRanking, len(list))
	for _, v := range list {
		m[v.UserEmail] = v
	}

	return m
}
func extractEmailUsername(email string) string {
	if email == "" {
		return email
	}

	ret := strings.Split(email, "@")
	return ret[0]
}
