package performance

import (
	"context"
	"time"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetStaffPerformanceListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetStaffPerformanceListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetStaffPerformanceListLogic {
	return &GetStaffPerformanceListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetStaffPerformanceListLogic) GetStaffPerformanceList(req *types.GetStaffPerformanceListReq) (resp *types.GetStaffPerformanceListResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.GetStaffPerformanceListReq{
		UserEmail: userEmail,
		Year:      req.Year,
		MonthNum:  req.MonthNum,
	}
	out, err := l.svcCtx.PerformanceRpc.GetStaffPerformanceList(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.GetStaffPerformanceList", logx.Field("error", err))
		return nil, err
	}

	resp = &types.GetStaffPerformanceListResp{List: make([]types.Performance, len(out.List))}
	for i, p := range out.List {
		resp.List[i] = types.Performance{
			ID:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			LeaderWords:        p.LeaderWords,
			Status:             int32(p.Status),
			CreatedAt:          p.CreatedAt.AsTime().Local().Format(time.DateTime),
			UpdatedAt:          p.UpdatedAt.AsTime().Local().Format(time.DateTime),
		}
	}
	return
}
