package performance

import (
	"context"
	"time"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetStaffPerformanceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetStaffPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetStaffPerformanceLogic {
	return &GetStaffPerformanceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetStaffPerformanceLogic) GetStaffPerformance(req *types.GetStaffPerformanceReq) (resp *types.GetStaffPerformanceResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.GetStaffPerformanceReq{
		StaffEmail: req.UserEmail,
		UserEmail:  userEmail,
		Year:       req.Year,
		MonthNum:   req.MonthNum,
	}
	out, err := l.svcCtx.PerformanceRpc.GetStaffPerformance(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.GetStaffPerformance", logx.Field("error", err))
		return
	}

	resp = &types.GetStaffPerformanceResp{List: make([]types.Performance, len(out.List))}
	for i, p := range out.List {
		resp.List[i] = types.Performance{
			ID:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			Level:              p.Level,
			LeaderWords:        p.LeaderWords,
			Status:             int32(p.Status),
			CreatedAt:          p.CreatedAt.AsTime().Local().Format(time.DateTime),
			UpdatedAt:          p.UpdatedAt.AsTime().Local().Format(time.DateTime),
		}
	}

	return
}
