package performance

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type InformToWritePerformanceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewInformToWritePerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *InformToWritePerformanceLogic {
	return &InformToWritePerformanceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *InformToWritePerformanceLogic) InformToWritePerformance(req *types.InformToWritePerformanceReq) (resp *types.InformToWritePerformanceResp, err error) {
	_, err = l.svcCtx.PerformanceRpc.InformToWritePerformance(l.ctx, &oa.InformToWritePerformanceReq{
		UserEmails:   req.UserEmails,
		Year:         req.Year,
		MonthNum:     req.MonthNum,
		SingedInUser: l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
	})
	if err != nil {
		logx.Errorw("failed to call reportrpc.InformToWritePerformance", logx.Field("error", err))
		return nil, err
	}
	return &types.InformToWritePerformanceResp{}, nil
}
