package performance

import (
	"context"
	"fmt"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/app/oacenter/oa_rpc/oa"
)

type InformPerformanceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewInformPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *InformPerformanceLogic {
	return &InformPerformanceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *InformPerformanceLogic) InformPerformance(req *types.InformPerformanceReq) (resp *types.InformPerformanceResp, err error) {
	// todo: add your logic here and delete this line
	//userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	var larkUserList []*oa.LarkUserList
	for _, v := range req.LarkUserList {
		larkUserList = append(larkUserList, &oa.LarkUserList{
			Email:  v.Email,
			Status: v.Status,
		})
	}
	in := &performancerpc.InformPerformanceReq{
		Year:          req.Year,
		MonthNum:      req.MonthNum,
		DepartmentKey: req.DepartmentKey,
		LarkUserList:  larkUserList,
	}
	response, err := l.svcCtx.PerformanceRpc.InformPerformance(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.InformPerformance", logx.Field("error", err))
		return
	}
	fmt.Println(response)
	return
}
