package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type LeaderWordsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewLeaderWordsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *LeaderWordsLogic {
	return &LeaderWordsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *LeaderWordsLogic) LeaderWords(req *types.LeaderWordsReq) (resp *types.LeaderWordsResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.LeaderWordsReq{
		UserEmail:     userEmail,
		PerformanceId: req.PerformanceID,
		LeaderWords:   req.LeaderWords,
	}
	_, err = l.svcCtx.PerformanceRpc.LeaderWords(l.ctx, in)

	return
}
