package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type PerfomanceSelfAckLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewPerfomanceSelfAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PerfomanceSelfAckLogic {
	return &PerfomanceSelfAckLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *PerfomanceSelfAckLogic) PerfomanceSelfAck(req *types.PerformanceSelfAckReq) (resp *types.PerformanceSelfAckResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.PerformanceSelfAckReq{UserEmail: userEmail, PerformanceId: req.PerformanceID}
	_, err = l.svcCtx.PerformanceRpc.PerformanceSelfAck(l.ctx, in)

	return
}
