package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type PerformanceLeaderAckLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewPerformanceLeaderAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PerformanceLeaderAckLogic {
	return &PerformanceLeaderAckLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *PerformanceLeaderAckLogic) PerformanceLeaderAck(req *types.PerformanceLeaderAckReq) (resp *types.PerformanceLeaderAckResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.PerformanceLeaderAckReq{UserEmail: userEmail, PerformanceId: req.PerformanceID}
	_, err = l.svcCtx.PerformanceRpc.PerformanceLeaderAck(l.ctx, in)

	return
}
