package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type RollbackPerformanceStatusLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewRollbackPerformanceStatusLogic(ctx context.Context, svcCtx *svc.ServiceContext) *RollbackPerformanceStatusLogic {
	return &RollbackPerformanceStatusLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *RollbackPerformanceStatusLogic) RollbackPerformanceStatus(req *types.RollbackPerformanceStatusReq) (resp *types.RollbackPerformanceStatusResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)
	in := &oa.RollbackPerformanceStatusReq{
		UserEmail:     user.Email,
		PerformanceId: req.PerformanceID,
	}

	_, err = l.svcCtx.PerformanceRpc.RollbackPerformanceStatus(l.ctx, in)
	return
}
