package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceAdditionItemLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceAdditionItemLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceAdditionItemLogic {
	return &UpdatePerformanceAdditionItemLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceAdditionItemLogic) UpdatePerformanceAdditionItem(req *types.UpdatePerformanceAdditionItemReq) (resp *types.UpdatePerformanceAdditionItemResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.UpdatePerformanceAdditionItemReq{
		UserEmail:     userEmail,
		ItemId:        req.ItemID,
		ItemDesc:      req.ItemDesc,
		SelfScore:     req.SelfScore,
		LeaderScore:   req.LeaderScore,
		CoworkerEmail: req.CoworkerEmail,
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceAdditionItem(l.ctx, in)

	return
}
