package performance

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceAdditionScoreLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceAdditionScoreLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceAdditionScoreLogic {
	return &UpdatePerformanceAdditionScoreLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceAdditionScoreLogic) UpdatePerformanceAdditionScore(req *types.UpdatePerformanceAdditionScoreReq) (resp *types.UpdatePerformanceAdditionScoreResp, err error) {
	// todo: add your logic here and delete this line
	in := &oa.UpdatePerformanceAdditionScoreReq{
		ItemId:    req.ItemId,
		Score:     req.Score,
		ItemDesc:  req.ItemDesc,
		UserEmail: l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceAdditionScore(l.ctx, in)
	return
}
