package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceBonusLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceBonusLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceBonusLogic {
	return &UpdatePerformanceBonusLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceBonusLogic) UpdatePerformanceBonus(req *types.UpdatePerformanceBonusReq) (resp *types.UpdatePerformanceBonusResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.UpdatePerformanceBonusReq{
		UserEmail:               userEmail,
		PerformanceId:           req.PerformanceID,
		TimeFactor:              req.TimeFactor,
		LevelFactor:             req.LevelFactor,
		IncidentDeduction:       req.IncidentDeduction,
		ExcellentMemberBonus:    req.ExcellentMemberBonus,
		ExcellentManagerBonus:   req.ExcellentManagerBonus,
		IsExcellentEmployee:     req.IsExcellentEmployee,
		ExcellentEmployeeReason: req.ExcellentEmployeeReason,
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceBonus(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.UpdatePerformanceBonus", logx.Field("error", err))
		return nil, err
	}

	return
}
