package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceItemCommentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceItemCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceItemCommentLogic {
	return &UpdatePerformanceItemCommentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceItemCommentLogic) UpdatePerformanceItemComment(req *types.UpdatePerformanceItemCommentReq) (resp *types.UpdatePerformanceItemCommentResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.UpdatePerformanceItemCommentReq{
		UserEmail:     userEmail,
		PerformanceId: req.PerformanceID,
		CommentId:     req.CommentID,
		Comment:       req.Comment,
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceItemComment(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("faield to call performanceRpc.UpdatePerformanceItemComment", logx.Field("error", err))
		return nil, err
	}

	return &types.UpdatePerformanceItemCommentResp{}, nil
}
