package performance

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceStatusUpdateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceStatusUpdateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceStatusUpdateLogic {
	return &UpdatePerformanceStatusUpdateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceStatusUpdateLogic) UpdatePerformanceStatusUpdate(req *types.UpdatePerformanceStatusUpdateReq) (resp *types.UpdatePerformanceStatusUpdateResp, err error) {
	// todo: add your logic here and delete this line
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.UpdatePerformanceStatusUpdateReq{
		UserEmail:     userEmail,
		PerformanceId: req.PerformanceID,
		Status:        req.Status,
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceStatusUpdate(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call performanceRpc.UpdatePerformanceStatusUpdate", logx.Field("error", err))
		return nil, err
	}
	return
}
