package performance

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceWorkItemLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdatePerformanceWorkItemLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceWorkItemLogic {
	return &UpdatePerformanceWorkItemLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdatePerformanceWorkItemLogic) UpdatePerformanceWorkItem(req *types.UpdatePerformanceWorkItemReq) (resp *types.UpdatePerformanceWorkItemResp, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &performancerpc.UpdatePerformanceWorkItemReq{
		UserEmail:     userEmail,
		ItemId:        req.ItemID,
		ItemName:      req.ItemName,
		ItemWeight:    req.ItemWeight,
		ItemDesc:      req.ItemDesc,
		ItemDeficency: req.ItemDeficency,
		SelfScore:     req.SelfScore,
		LeaderScore:   req.LeaderScore,
	}
	_, err = l.svcCtx.PerformanceRpc.UpdatePerformanceWorkItem(l.ctx, in)

	return
}
