package public

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateIssueMetricsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateIssueMetricsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateIssueMetricsLogic {
	return &CreateIssueMetricsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateIssueMetricsLogic) CreateIssueMetrics(req *types.CreateIssueMetricsReq) (resp *types.BaseResp, err error) {
	rpcReq := &oa.CreateIssueMetricsReq{
		PeriodType:    req.PeriodType,
		Employee:      req.Employee,
		DepartmentKey: req.DepartmentKey,
		DateFromTo:    req.DateFromTo,
		ProjectKey:    req.ProjectKey,
		Role:          oa.Role(req.Role),
	}

	for _, v := range req.Infos.Data {
		rpcReq.Infos = append(rpcReq.Infos, &oa.Infos{
			Reason:   v.Reason,
			Type:     v.Type,
			Priority: v.Priority,
			Count:    v.Count,
		})
	}
	_, err = l.svcCtx.IssueRpc.CreateIssueMetrics(l.ctx, rpcReq)
	if err != nil {
		return nil, err
	}
	return &types.BaseResp{
		Code: 0,
		Msg:  "success",
	}, nil
}
