package public

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateMonitorMetricsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateMonitorMetricsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateMonitorMetricsLogic {
	return &CreateMonitorMetricsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateMonitorMetricsLogic) CreateMonitorMetrics(req *types.CreateMonitorMetricsReq) (err error) {
	_, err = l.svcCtx.MonitorRpc.CreateMonitorMetrics(l.ctx, &oa.CreateMonitorMetricsReq{
		PeriodType:             int64(req.PeriodType),
		Employee:               req.Employee,
		DateFromTo:             req.DateFromTo,
		FailureRecurrenceRate:  req.FailureRecurrenceRate,
		AverageProcessingTime:  req.AverageProcessingTime,
		AverageResolutionTime:  req.AverageResolutionTime,
		EffectiveHandledEvents: req.EffectiveHandledEvents,
		BizRuleHitRate:         req.BizRuleHitRate,
		BizEventAssignmentRate: req.BizEventAssignmentRate,
		TotalEvents:            int64(req.TotalEvents),
	})
	return err
}
