package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateReportCommentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateReportCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateReportCommentLogic {
	return &CreateReportCommentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateReportCommentLogic) CreateReportComment(req *types.CreateReportCommentReq) (resp *types.CreateReportCommentResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	in := &oa.CreateReportCommentReq{
		UserEmail: user.Email,
		ReportId:  req.ReportID,
		Content:   req.Content,
	}
	out, err := l.svcCtx.ReportRpc.CreateReportComment(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.CreateReportComment", logx.Field("error", err))
		return nil, err
	}

	return &types.CreateReportCommentResp{ReportCommentID: out.GetReportCommentId()}, nil
}
