package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateReportLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateReportLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateReportLogic {
	return &CreateReportLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateReportLogic) CreateReport(req *types.CreateReportReq) (resp *types.CreateReportResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	items := make([]*oa.ReportItemForModify, len(req.ReportItemList))
	for i, v := range req.ReportItemList {
		items[i] = &oa.ReportItemForModify{
			Content:     v.Content,
			MentionList: v.MentionList,
		}
	}
	in := &oa.CreateReportReq{
		UserEmail:      user.Email,
		ReportType:     oa.ReportType(req.ReportType),
		ReportDate:     req.ReportDate,
		IsDelayed:      req.IsDelayed,
		DelayReason:    req.DelayReason,
		HasRisk:        req.HasRisk,
		RiskDesc:       req.RiskDesc,
		IsDraft:        req.IsDraft,
		ReportItemList: items,
	}

	out, err := l.svcCtx.ReportRpc.CreateReport(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.CreateReport", logx.Field("error", err))
		return nil, err
	}

	return &types.CreateReportResp{ReportID: out.GetReportId()}, nil
}
