package report

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetReportStatisticsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetReportStatisticsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetReportStatisticsLogic {
	return &GetReportStatisticsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetReportStatisticsLogic) GetReportStatistics(req *types.ReportStatisticsReq) (resp *types.ReportStatisticsResp, err error) {
	r, err := l.svcCtx.ReportRpc.GetReportStatistics(l.ctx, &oa.ReportStatisticsReq{
		ReportStartDate: req.ReportStartDate,
		ReportEndDate:   req.ReportEndDate,
		UserEmail:       l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
	})
	if err != nil {
		return nil, err
	}
	rtn := &types.ReportStatisticsResp{
		Departments: types.Departments{
			Level3: make([]types.DepartmentStatistics, 0),
			Level4: make([]types.DepartmentStatistics, 0),
			Level5: make([]types.DepartmentStatistics, 0),
		},
	}

	copyDepartmentStatistics := func(d *oa.DepartmentStatistics) (copy_ *types.DepartmentStatistics) {
		department := types.DepartmentStatistics{
			DepartmentKey:     d.DepartmentKey,
			DepartmentName:    d.DepartmentName,
			ReportTypeToCount: d.ReportTypeToCount,
			ReportDateToCount: d.ReportDateToCount,
			Individuals:       nil,
		}
		for _, i := range d.GetIndividuals() {
			department.Individuals = append(department.Individuals, types.IndividualStatistics{
				UserEmail:         i.UserEmail,
				ReportTypeToCount: i.ReportTypeToCount,
				ReportDateToCount: i.ReportDateToCount,
			})
		}
		return &department
	}

	for _, d := range r.GetDepartments().GetLevel3() {
		rtn.Departments.Level3 = append(rtn.Departments.Level3, *copyDepartmentStatistics(d))
	}
	for _, d := range r.GetDepartments().GetLevel4() {
		rtn.Departments.Level4 = append(rtn.Departments.Level4, *copyDepartmentStatistics(d))
	}
	for _, d := range r.GetDepartments().GetLevel5() {
		rtn.Departments.Level5 = append(rtn.Departments.Level5, *copyDepartmentStatistics(d))
	}
	return rtn, nil
}
